// 【リレーシールドを制御】
// (A) 駆動用モーター
// 指定されたモーターを停止
void motorStop(char port) {   //char portで構成されるmotorstop(戻り値)という名前の関数。この関数は戻り値がない
  digitalWrite(port,     LOW);//portはすべての変数を代入できるのか？
  digitalWrite(port + 1, LOW);
}
// 指定されたモーターを前進
void motorFWD(char port) {
  digitalWrite(port,     HIGH);
  digitalWrite(port + 1, LOW);
}
// 指定されたモーターを後進
void motorBWD(char port) {
  digitalWrite(port,     LOW);
  digitalWrite(port + 1, HIGH);
}
// (B) 関節部モーター
// 関節部モーターを停止
void jointSTOP() {
  digitalWrite(DO_JT1, LOW);
  digitalWrite(DO_JT2, LOW);
  change_joint_target_abs(j_angle_now); // 目標値を現在の角度にセットし，
  driving_joint = false;                // 制御フラグをリセットして制御を止める．
}
// 関節部モーターをCCWに回転開始
void jointCCW() {
  digitalWrite(DO_JT1, HIGH);
  digitalWrite(DO_JT2, LOW);
}
// 関節部モーターをCWに回転開始
void jointCW() {
  digitalWrite(DO_JT1, LOW);
  digitalWrite(DO_JT2, HIGH);
}

// 【駆動モーターを制御】
// (1) 各モーター
void motorFWD_RA()  { motorRA =  1; }
void motorBWD_RA()  { motorRA = -1; }
void motorStop_RA() { motorRA =  0; }
void motorFWD_LA()  { motorLA =  1; }
void motorBWD_LA()  { motorLA = -1; }
void motorStop_LA() { motorLA =  0; }
void motorFWD_RB()  { motorRB =  1; }
void motorBWD_RB()  { motorRB = -1; }
void motorStop_RB() { motorRB =  0; }
void motorFWD_LB()  { motorLB =  1; }
void motorBWD_LB()  { motorLB = -1; }
void motorStop_LB() { motorLB =  0; }
// (2) 左右モーターセット
void motorFWD_R()  { motorFWD_RA();   motorFWD_RB();  }
void motorBWD_R()  { motorBWD_RA();   motorBWD_RB();  }
void motorStop_R() { motorStop_RA();  motorStop_LA(); }
void motorFWD_L()  { motorFWD_LA();   motorFWD_LB();  }
void motorBWD_L()  { motorBWD_LA();   motorBWD_LB();  }
void motorStop_L() { motorStop_LA();  motorStop_LB(); }
// (3) 前後モーターセット
void motorFWD_A()  { motorFWD_RA();   motorFWD_LA();  }
void motorBWD_A()  { motorBWD_RA();   motorBWD_LA();  }
void motorStop_A() { motorStop_RA();  motorStop_LA(); }
void motorFWD_B()  { motorFWD_RB();   motorFWD_LB();  }
void motorBWD_B()  { motorBWD_RB();   motorBWD_LB();  }
void motorStop_B() { motorStop_RB();  motorStop_LB(); }
// 全駆動モーターセット
void motorFWD_all()  { motorFWD_A(); motorFWD_B(); }
void motorBWD_all()  { motorBWD_A(); motorBWD_B(); }
void motorStop_all() { 
  motorStop_A(); motorStop_B();
  motorStop(MOTOR_RA);  motorStop(MOTOR_RB);  motorStop(MOTOR_LA);  motorStop(MOTOR_LB);
}
// 全モーター停止
void allmotorStop() {
  motorStop_all();
  jointSTOP();
}
